/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringsResourceTranslator {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Pattern ENTRY_PATTERN = Pattern.compile("<string name=\"([^\"]+)\">([^<]+)</string>");
    private static final Pattern STRINGS_FILE_NAME_PATTERN = Pattern.compile("values-(.+)");
    private static final Pattern TRANSLATE_RESPONSE_PATTERN = Pattern.compile("\\{\"translatedText\":\"([^\"]+)\"\\}");
    private static final String APACHE_2_LICENSE = "<!--\n Copyright (C) 2010 ZXing authors\n\n Licensed under the Apache License, Version 2.0 (the \"License\");\n you may not use this file except in compliance with the License.\n You may obtain a copy of the License at\n\n      http://www.apache.org/licenses/LICENSE-2.0\n\n Unless required by applicable law or agreed to in writing, software\n distributed under the License is distributed on an \"AS IS\" BASIS,\n WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n See the License for the specific language governing permissions and\n limitations under the License.\n -->\n";
    private static final Map<String, String> LANGUAGE_CODE_MASSAGINGS = new HashMap<String, String>(7);

    private StringsResourceTranslator() {
    }

    public static void main(String[] args) throws IOException {
        File[] translatedValuesDirs;
        File resDir = new File(args[0]);
        File valueDir = new File(resDir, "values");
        File stringsFile = new File(valueDir, "strings.xml");
        List<String> forceRetranslation = Arrays.asList(args).subList(1, args.length);
        for (File translatedValuesDir : translatedValuesDirs = resDir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() && file.getName().startsWith("values-");
            }
        })) {
            File translatedStringsFile = new File(translatedValuesDir, "strings.xml");
            StringsResourceTranslator.translate(stringsFile, translatedStringsFile, forceRetranslation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void translate(File englishFile, File translatedFile, Collection<String> forceRetranslation) throws IOException {
        SortedMap<String, String> english = StringsResourceTranslator.readLines(englishFile);
        SortedMap<String, String> translated = StringsResourceTranslator.readLines(translatedFile);
        String parentName = translatedFile.getParentFile().getName();
        Matcher stringsFileNameMatcher = STRINGS_FILE_NAME_PATTERN.matcher(parentName);
        stringsFileNameMatcher.find();
        String language = stringsFileNameMatcher.group(1);
        String massagedLanguage = LANGUAGE_CODE_MASSAGINGS.get(language);
        if (massagedLanguage != null) {
            language = massagedLanguage;
        }
        System.out.println("Translating " + language);
        File resultTempFile = File.createTempFile(parentName, ".xml");
        boolean anyChange = false;
        OutputStreamWriter out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(resultTempFile), UTF8);
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            out.write(APACHE_2_LICENSE);
            out.write("<resources>\n");
            for (Map.Entry<String, String> englishEntry : english.entrySet()) {
                String key = englishEntry.getKey();
                out.write("  <string name=\"");
                out.write(key);
                out.write("\">");
                String translatedString = (String)translated.get(key);
                if (translatedString == null || forceRetranslation.contains(key)) {
                    anyChange = true;
                    translatedString = StringsResourceTranslator.translateString(englishEntry.getValue(), language);
                }
                out.write(translatedString);
                out.write("</string>\n");
            }
            out.write("</resources>\n");
            ((Writer)out).flush();
        }
        catch (Throwable throwable) {
            StringsResourceTranslator.quietClose(out);
            throw throwable;
        }
        StringsResourceTranslator.quietClose(out);
        if (anyChange) {
            System.out.println("  Writing translations");
            translatedFile.delete();
            resultTempFile.renameTo(translatedFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String translateString(String english, String language) throws IOException {
        System.out.println("  Need translation for " + english);
        URL translateURL = new URL("http://ajax.googleapis.com/ajax/services/language/translate?v=1.0&q=" + URLEncoder.encode(english, "UTF-8") + "&langpair=en%7C" + language);
        StringBuilder translateResult = new StringBuilder();
        InputStreamReader in = null;
        try {
            int charsRead;
            in = new InputStreamReader(translateURL.openStream(), UTF8);
            char[] buffer = new char[1024];
            while ((charsRead = in.read(buffer)) > 0) {
                translateResult.append(buffer, 0, charsRead);
            }
        }
        catch (Throwable throwable) {
            StringsResourceTranslator.quietClose(in);
            throw throwable;
        }
        StringsResourceTranslator.quietClose(in);
        Matcher m = TRANSLATE_RESPONSE_PATTERN.matcher(translateResult);
        if (!m.find()) {
            throw new IOException("No translate result");
        }
        String translation = m.group(1);
        System.out.println("  Got translation " + translation);
        return translation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SortedMap<String, String> readLines(File file) throws IOException {
        TreeMap<String, String> treeMap;
        TreeMap<String, String> entries = new TreeMap<String, String>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), UTF8));
            while ((line = reader.readLine()) != null) {
                Matcher m = ENTRY_PATTERN.matcher(line);
                if (!m.find()) continue;
                String key = m.group(1);
                String value = m.group(2);
                entries.put(key, value);
            }
            treeMap = entries;
        }
        catch (Throwable throwable) {
            StringsResourceTranslator.quietClose(reader);
            throw throwable;
        }
        StringsResourceTranslator.quietClose(reader);
        return treeMap;
    }

    private static void quietClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        LANGUAGE_CODE_MASSAGINGS.put("ja-rJP", "ja");
        LANGUAGE_CODE_MASSAGINGS.put("zh-rCN", "zh-cn");
        LANGUAGE_CODE_MASSAGINGS.put("zh-rTW", "zh-tw");
        LANGUAGE_CODE_MASSAGINGS.put("kr", "ko");
    }
}

