/*
 * Decompiled with CFR 0.152.
 */
package TrainBase;

import TrainBase.Main;
import TrainBase.Program_Create_PDF;
import TrainBase.Program_Log;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;

public class Frame_Info {
    private JFrame frame = new JFrame();
    public String Text;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Frame_Info window = new Frame_Info();
                    window.frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public Frame_Info() {
        this.initialize();
        new Program_Log("Frame_Info");
    }

    private void initialize() {
        LocalDate end;
        LocalDate start;
        long diffInDays;
        this.frame.setResizable(false);
        this.frame.setBounds(100, 100, 400, 498);
        this.frame.setFont(Main.myFont);
        this.frame.setIconImage(Toolkit.getDefaultToolkit().getImage(Main.class.getResource("/TrainBase/images/Icon.png")));
        this.frame.setAlwaysOnTop(true);
        this.frame.setLocationRelativeTo(null);
        this.frame.setDefaultCloseOperation(2);
        this.frame.setTitle("Empty");
        this.frame.setUndecorated(true);
        this.frame.getContentPane().setLayout(null);
        JDesktopPane desktopPane = new JDesktopPane();
        desktopPane.setBackground(new Color(192, 192, 192));
        desktopPane.setBorder(new BevelBorder(0, null, null, null, null));
        desktopPane.setBounds(0, 0, 400, 498);
        this.frame.getContentPane().add(desktopPane);
        JLabel lbl_Icon = new JLabel("");
        lbl_Icon.setIcon(new ImageIcon(Frame_Info.class.getResource("/TrainBase/images/INFORMATION_MESSAGE.png")));
        lbl_Icon.setBounds(10, 11, 50, 50);
        desktopPane.add(lbl_Icon);
        JLabel lbl_Koptekst = new JLabel("Programma Info");
        lbl_Koptekst.setHorizontalAlignment(0);
        lbl_Koptekst.setFont(new Font("SansSerif", 1, 15));
        lbl_Koptekst.setBounds(10, 30, 380, 20);
        desktopPane.add(lbl_Koptekst);
        this.Text = "TrainBase Pro (c) Copyright " + Main.dtf3.format(Main.dateNow) + "\nRechten: UniekSoft (c) " + Main.dtf3.format(Main.dateNow) + "\nProgramma versie " + Main.ProgramVersion;
        this.Text = this.Text + "\nGe\u00efnstalleerd op: " + Main.InstalDate;
        this.Text = this.Text + "\n\nInstallatie Map: " + Main.ProgramPath + Main.Separator;
        this.Text = this.Text + "\nDataBase Map: " + Main.DataBase_Path + Main.Separator;
        this.Text = this.Text + "\nBackup Map: " + Main.Backup_Path + Main.Separator;
        this.Text = Main.BackupDate.contains("null") ? String.valueOf(this.Text) + "\nEr is nog geen backup gemaakt van de DataBase." : this.Text + "\nLaatste backup is gemaakt op: " + Main.BackupDate + " om " + Main.BackupTime + " uur";
        this.Text = this.Text + "\n\nDe DataBase bevat: " + Main.RecordCount + " Items:\n";
        this.Text = this.Text + Main.tbl_Tab1_Locomotieven.getRowCount() + " - Locomotieven.\n";
        this.Text = this.Text + Main.tbl_Tab2_Wagons.getRowCount() + " - Wagons.\n";
        this.Text = this.Text + Main.tbl_Tab3_Rails.getRowCount() + " - Rails types.\n";
        this.Text = this.Text + Main.tbl_Tab4_Interfaces.getRowCount() + " - Interfaces.\n";
        this.Text = this.Text + Main.tbl_Tab5_Accessoires.getRowCount() + " - Accessoires.\n";
        this.Text = this.Text + Main.tbl_Tab6_Scenery.getRowCount() + " - Scenery 's.\n";
        this.Text = this.Text + Main.tbl_Tab7_Documenten.getRowCount() + " - Document categorie\u00ebn.\n\n";
        this.Text = this.Text + "Operating systeem: " + Main.OsName + "\n";
        this.Text = this.Text + "Java versie: " + Main.JavaJRE + "\n";
        this.Text = this.Text + "Java installatie Map: " + Main.JavaPath + Main.Separator + "\n\n";
        this.Text = Main.licentieKey ? this.Text + "Gebruikers licentie verleend aan: " + Main.licentieName : ((diffInDays = ChronoUnit.DAYS.between(start = LocalDate.now(), end = LocalDate.parse(Main.stf1.format(Main.dte_Tab0_EndDate.getDate())))) > 0L ? this.Text + "Uw gratis gebruikers Licentie loopt af over " + diffInDays + " dagen." : String.valueOf(this.Text) + "Uw gratis gebruikers Licentie is verlopen.");
        JTextArea txa_TekstVeld = new JTextArea();
        txa_TekstVeld.setBackground(new Color(192, 192, 192));
        txa_TekstVeld.setText(this.Text);
        txa_TekstVeld.setFont(Main.myFont);
        txa_TekstVeld.setBounds(10, 75, 380, 378);
        desktopPane.add(txa_TekstVeld);
        JButton btn_Sluiten = new JButton("Sluiten");
        btn_Sluiten.setToolTipText("Venster sluiten");
        btn_Sluiten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.frame.setEnabled(true);
                Frame_Info.this.frame.dispose();
            }
        });
        btn_Sluiten.setFont(Main.myFont);
        btn_Sluiten.setBorder(new BevelBorder(0, null, null, null, null));
        btn_Sluiten.setBounds(120, 464, 75, 23);
        desktopPane.add(btn_Sluiten);
        JButton btn_Print = new JButton("Overzicht");
        btn_Print.setToolTipText("Genereer een overzicht van deze Info");
        btn_Print.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Program_Create_PDF(9, Frame_Info.this.Text);
                Main.frame.setEnabled(true);
                Frame_Info.this.frame.dispose();
            }
        });
        btn_Print.setFont(new Font("SansSerif", 0, 11));
        btn_Print.setBorder(new BevelBorder(0, null, null, null, null));
        btn_Print.setBounds(202, 464, 75, 23);
        desktopPane.add(btn_Print);
        this.frame.setVisible(true);
    }
}

