/*
 * Decompiled with CFR 0.152.
 */
package TrainBase;

import TrainBase.Main;
import TrainBase.Program_Config;
import TrainBase.Program_Log;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;

public class Frame_Backup {
    private JFrame frame = new JFrame();
    private boolean Restart = false;
    private JTextArea txa_Info = new JTextArea();
    private JButton btn_Restore = new JButton("Restore");
    private JButton btn_Backup = new JButton("Back-Up");

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Frame_Backup window = new Frame_Backup();
                    window.frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public Frame_Backup() {
        this.initialize();
        new Program_Log("Frame_Backup");
    }

    private void initialize() {
        this.frame.setResizable(false);
        this.frame.setBounds(100, 100, 400, 231);
        this.frame.setFont(Main.myFont);
        this.frame.setIconImage(Toolkit.getDefaultToolkit().getImage(Main.class.getResource("/TrainBase/images/Icon.png")));
        this.frame.setAlwaysOnTop(true);
        this.frame.setLocationRelativeTo(null);
        this.frame.setDefaultCloseOperation(2);
        this.frame.setTitle("Empty");
        this.frame.setUndecorated(true);
        this.frame.getContentPane().setLayout(null);
        JDesktopPane desktopPane = new JDesktopPane();
        desktopPane.setBackground(new Color(192, 192, 192));
        desktopPane.setBorder(new BevelBorder(0, null, null, null, null));
        desktopPane.setBounds(0, 0, 400, 231);
        this.frame.getContentPane().add(desktopPane);
        JLabel lbl_Icon = new JLabel("");
        lbl_Icon.setIcon(new ImageIcon(Frame_Backup.class.getResource("/TrainBase/images/BACKUP_MESSAGE.png")));
        lbl_Icon.setBounds(10, 11, 50, 50);
        desktopPane.add(lbl_Icon);
        JLabel lbl_Koptekst = new JLabel("Back-up DataBase");
        lbl_Koptekst.setHorizontalAlignment(0);
        lbl_Koptekst.setFont(new Font("SansSerif", 1, 15));
        lbl_Koptekst.setBounds(10, 30, 380, 20);
        desktopPane.add(lbl_Koptekst);
        Object Text2 = "";
        if (Main.BackupDate.contains("null")) {
            Text2 = "\nEr is nog geen Back-Up gemaakt van de DataBase.\n\n";
            this.btn_Restore.setEnabled(false);
        } else {
            Text2 = "\nLaatste Back-Up is gemaakt op: " + Main.BackupDate + " om " + Main.BackupTime + " uur\n\n";
        }
        Text2 = (String)Text2 + "Maak nu een nieuwe Back-Up of Restore de laatst gemaakte Back-Up.";
        this.txa_Info.setBackground(new Color(192, 192, 192));
        this.txa_Info.setWrapStyleWord(true);
        this.txa_Info.setLineWrap(true);
        this.txa_Info.setText((String)Text2);
        this.txa_Info.setFont(Main.myFont);
        this.txa_Info.setBounds(10, 72, 380, 74);
        desktopPane.add(this.txa_Info);
        JButton btn_Sluiten = new JButton("Sluiten");
        btn_Sluiten.setToolTipText("Venster sluiten.");
        btn_Sluiten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Frame_Backup.this.Restart) {
                    System.exit(0);
                } else {
                    Main.frame.setEnabled(true);
                    Frame_Backup.this.frame.dispose();
                }
            }
        });
        btn_Sluiten.setFont(Main.myFont);
        btn_Sluiten.setBorder(new BevelBorder(0, null, null, null, null));
        btn_Sluiten.setBounds(159, 193, 89, 23);
        desktopPane.add(btn_Sluiten);
        this.btn_Backup.setToolTipText("Back-Up DataBase.");
        this.btn_Backup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Path dir = Paths.get(Main.Backup_Path, new String[0]);
                    if (Files.exists(dir, new LinkOption[0])) {
                        Files.walk(dir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
                            try {
                                Files.delete(path);
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        });
                    }
                    Path path2 = Paths.get(Main.Backup_Path, new String[0]);
                    Files.createDirectories(path2, new FileAttribute[0]);
                    Path sourceDir = Paths.get(Main.DataBase_Path, new String[0]);
                    Path destinationDir = Paths.get(Main.Backup_Path, new String[0]);
                    Files.walk(sourceDir, new FileVisitOption[0]).forEach(sourcePath -> {
                        Path targetPath = destinationDir.resolve(sourceDir.relativize((Path)sourcePath));
                        try {
                            Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    });
                    Date dateNow = new Date();
                    Main.BackupDate = Main.dtf1.format(dateNow).toString();
                    Main.BackupTime = Main.dtf4.format(dateNow).toString();
                    new Program_Config(1);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    System.out.println("Error - Class_Backup_DataBase: " + String.valueOf(e1));
                }
                String Text2 = "\nEen nieuwe backup is gemaakt op: " + Main.BackupDate + " om " + Main.BackupTime + " uur\n\n";
                Frame_Backup.this.txa_Info.setText(Text2);
                Frame_Backup.this.btn_Restore.setEnabled(false);
                Frame_Backup.this.btn_Backup.setEnabled(false);
            }
        });
        this.btn_Backup.setFont(Main.myFont);
        this.btn_Backup.setBorder(new BevelBorder(0, null, null, null, null));
        this.btn_Backup.setBounds(108, 157, 89, 23);
        desktopPane.add(this.btn_Backup);
        this.btn_Restore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Path dir = Paths.get(Main.DataBase_Path, new String[0]);
                    if (Files.exists(dir, new LinkOption[0])) {
                        Files.walk(dir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
                            try {
                                Files.delete(path);
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        });
                    }
                    Path path2 = Paths.get(Main.DataBase_Path, new String[0]);
                    Files.createDirectories(path2, new FileAttribute[0]);
                    Path sourceDir = Paths.get(Main.Backup_Path, new String[0]);
                    Path destinationDir = Paths.get(Main.DataBase_Path, new String[0]);
                    Files.walk(sourceDir, new FileVisitOption[0]).forEach(sourcePath -> {
                        Path targetPath = destinationDir.resolve(sourceDir.relativize((Path)sourcePath));
                        try {
                            Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    });
                    String Text2 = "De laatste gemaakte Backup van " + Main.BackupDate + " is terug gezet op " + Main.dtf1.format(Main.dateNow) + " om " + Main.dtf4.format(Main.dateNow) + " uur\n\n";
                    Text2 = Text2 + "TrainBase Pro wordt nu afgesloten, start deze daarna opnieuw op om de DataBase opnieuw te lezen.";
                    Frame_Backup.this.txa_Info.setText(Text2);
                    Frame_Backup.this.btn_Restore.setEnabled(false);
                    Frame_Backup.this.btn_Backup.setEnabled(false);
                    Frame_Backup.this.Restart = true;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    System.out.println("Error - Class_Backup_DataBase: " + String.valueOf(e1));
                }
            }
        });
        this.btn_Restore.setToolTipText("Restore DataBase.");
        this.btn_Restore.setFont(Main.myFont);
        this.btn_Restore.setBorder(new BevelBorder(0, null, null, null, null));
        this.btn_Restore.setBounds(207, 158, 89, 23);
        desktopPane.add(this.btn_Restore);
        this.frame.setVisible(true);
    }
}

